package gov.va.vamf.scheduling.varutility.service;


import gov.va.vamf.scheduling.varutility.domain.ClinicalServices;
import gov.va.vamf.scheduling.varutility.domain.CoreSetting;
import gov.va.vamf.scheduling.varutility.domain.CoreSettings;
import gov.va.vamf.scheduling.varutility.domain.StopCodes;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static gov.va.vamf.scheduling.varutility.domain.CoreSettings.PRIMARY_CARE_ID;

@Service
public class CoreSettingsService {

    public CoreSettings createDefaultCoreSettings(List<ClinicalServices> clinicalServices) {

        CoreSettings cs = new CoreSettings();
        for (ClinicalServices service: clinicalServices) {
            Integer serviceSubmittedRequestLimit = service.getSubmittedRequestLimit();
            String serviceName = service.getName();
            String serviceId = service.getId();
            StopCodes serviceStopCodes = service.getStopCodes();
            cs = createCoreSettings(cs, serviceName, serviceId, serviceStopCodes, serviceSubmittedRequestLimit);
        }
        return cs;
    }

    public CoreSettings updateCriteriaCoreSettings(CoreSettings coreSettings, List<ClinicalServices> services) {

        Map<String,String> coreSettingsIds = new HashMap<String, String>();
        Map<String, String> servicesIds = new HashMap<String, String>();
        Map<String, StopCodes> serviceStopCodes = new HashMap<String, StopCodes>();
        Map<String, Integer> serviceSubmittedRequestLimits = new HashMap<String, Integer>();
        CoreSettings newCoreSettings = new CoreSettings();
        for (CoreSetting coreSetting: coreSettings) {
            coreSettingsIds.put(coreSetting.getId(), coreSetting.getTypeOfCare());
        }
        for (ClinicalServices clinicalService: services) {
            servicesIds.put(clinicalService.getId(), clinicalService.getName());
            serviceStopCodes.put(clinicalService.getId(), clinicalService.getStopCodes());
            serviceSubmittedRequestLimits.put(clinicalService.getId(), clinicalService.getSubmittedRequestLimit());
        }
        coreSettingsIds.keySet().retainAll(servicesIds.keySet());
        for (CoreSetting coreSetting: coreSettings) {
            String id = coreSetting.getId();
            if (coreSettingsIds.containsKey(id)) {
                coreSetting = determineSubmittedRequestLimit(coreSetting, serviceSubmittedRequestLimits, id);
                coreSetting.setStopCodes(serviceStopCodes.get(id));
                coreSetting.setEnterpriseSubmittedRequestLimit(serviceSubmittedRequestLimits.get(id));
                coreSetting.setTypeOfCare(servicesIds.get(id));
                newCoreSettings.add(coreSetting);
            }
        }
        servicesIds.keySet().removeAll(coreSettingsIds.keySet());

        for (Map.Entry<String, String> entry: servicesIds.entrySet()) {
            newCoreSettings = createCoreSettings(newCoreSettings, entry.getValue(), entry.getKey(), serviceStopCodes.get(entry.getKey()), serviceSubmittedRequestLimits.get(entry.getKey()));
        }
        return newCoreSettings;
    }

    private CoreSettings createCoreSettings(CoreSettings coreSettings, String serviceName, String serviceId, StopCodes stopCodes, Integer submittedRequestLimit) {

        coreSettings.add(new CoreSetting(serviceId, serviceName, "", 0, stopCodes, true, submittedRequestLimit, submittedRequestLimit));
        return coreSettings;
    }

    private CoreSetting determineSubmittedRequestLimit(CoreSetting coreSetting, Map<String, Integer> serviceSubmittedRequestLimits, String id) {
        if (coreSetting.getSubmittedRequestLimit()  == null) {
            coreSetting.setSubmittedRequestLimit(serviceSubmittedRequestLimits.get(id));
        }
        return coreSetting;
    }
}
